/*
 * Decompiled with CFR 0.152.
 */
package com.cyphercor.logintc;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.codec.Charsets;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

class AdminRestClient {
    private static final String CONTENT_TYPE = "application/vnd.logintc.v1+json";
    private String scheme = null;
    private String host = null;
    private Integer port = null;
    private String apiKey = null;
    private String userAgent = null;
    private DefaultHttpClient httpClient = null;

    public static AdminRestClient from(String apiKey, String host, Boolean secure, String userAgent) {
        Integer port = null;
        String scheme = secure != false ? "https" : "http";
        String[] hostParts = host.split(":");
        if (hostParts.length > 1) {
            host = hostParts[0];
            port = Integer.parseInt(hostParts[1]);
        } else {
            port = secure != false ? Integer.valueOf(443) : Integer.valueOf(80);
        }
        return new AdminRestClient(scheme, host, port, apiKey, userAgent);
    }

    private AdminRestClient(String scheme, String host, Integer port, String apiKey, String userAgent) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.apiKey = apiKey;
        this.userAgent = userAgent;
        this.httpClient = new DefaultHttpClient();
    }

    public void setProxy(String proxyHost, int proxyPort) {
        HttpHost proxy = new HttpHost(proxyHost, proxyPort, "http");
        this.httpClient.getParams().setParameter("http.route.default-proxy", proxy);
    }

    public void setProxy(String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        CredentialsProvider credsProvider = this.httpClient.getCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), new UsernamePasswordCredentials(proxyUser, proxyPassword));
        this.httpClient.setCredentialsProvider(credsProvider);
        HttpHost proxy = new HttpHost(proxyHost, proxyPort, "http");
        this.httpClient.getParams().setParameter("http.route.default-proxy", proxy);
    }

    public String get(String path) throws AdminRestClientException {
        return this.get(path, null);
    }

    public String get(String path, String query) throws AdminRestClientException {
        HttpGet request = new HttpGet(this.genUri(path, query));
        request.setHeader("Accept", CONTENT_TYPE);
        return new String(this.execute(request));
    }

    public byte[] getBytes(String path, String acceptHeader) throws AdminRestClientException {
        HttpGet request = new HttpGet(this.genUri(path));
        request.setHeader("Accept", acceptHeader);
        return this.execute(request);
    }

    public String post(String path, String body) throws AdminRestClientException {
        HttpPost request = new HttpPost(this.genUri(path));
        request.setHeader("Accept", CONTENT_TYPE);
        if (body != null) {
            request.setEntity(new StringEntity(body, Charsets.UTF_8));
            request.setHeader("Content-Type", CONTENT_TYPE);
        }
        return new String(this.execute(request));
    }

    public String put(String path, String body) throws AdminRestClientException {
        HttpPut request = new HttpPut(this.genUri(path));
        request.setHeader("Accept", CONTENT_TYPE);
        if (body != null) {
            request.setEntity(new StringEntity(body, Charsets.UTF_8));
            request.setHeader("Content-Type", CONTENT_TYPE);
        }
        return new String(this.execute(request));
    }

    public String delete(String path) throws AdminRestClientException {
        HttpDelete request = new HttpDelete(this.genUri(path));
        request.setHeader("Accept", CONTENT_TYPE);
        request.setHeader("Content-Length", "0");
        return new String(this.execute(request));
    }

    private byte[] execute(HttpRequestBase request) throws AdminRestClientException {
        byte[] responseBodyBytes = null;
        Integer statusCode = 0;
        request.setHeader("Host", this.genHostHeaderValue());
        request.setHeader("User-Agent", this.userAgent);
        request.setHeader("Authorization", String.format("LoginTC key=\"%s\"", this.apiKey));
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute(request);
        }
        catch (ClientProtocolException e) {
            throw new InternalAdminRestClientException(e);
        }
        catch (IOException e) {
            throw new InternalAdminRestClientException(e);
        }
        statusCode = response.getStatusLine().getStatusCode();
        try {
            responseBodyBytes = EntityUtils.toByteArray(response.getEntity());
        }
        catch (IOException e) {
            throw new InternalAdminRestClientException(e);
        }
        switch (statusCode) {
            case 200: 
            case 201: 
            case 202: {
                break;
            }
            default: {
                String responseBodyString = new String(responseBodyBytes);
                throw new RestAdminRestClientException(statusCode, responseBodyString);
            }
        }
        return responseBodyBytes;
    }

    private String genHostHeaderValue() {
        String host = this.host;
        if (this.scheme.equals("https") && this.port != 443) {
            host = host + ":" + this.port;
        } else if (this.scheme.equals("http") && this.port != 80) {
            host = host + ":" + this.port;
        }
        return host;
    }

    private URI genUri(String path) throws AdminRestClientException {
        return this.genUri(path, null);
    }

    private URI genUri(String path, String query) throws AdminRestClientException {
        try {
            return new URI(this.scheme, null, this.host, this.port, path, query, null);
        }
        catch (URISyntaxException e) {
            throw new InternalAdminRestClientException(e);
        }
    }

    public static class RestAdminRestClientException
    extends AdminRestClientException {
        private static final long serialVersionUID = 2848640201316730052L;
        private Integer statusCode = null;
        private String body = null;

        public RestAdminRestClientException(Integer statusCode, String body) {
            super("API returned status code " + statusCode.toString());
            this.statusCode = statusCode;
            this.body = body;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public String getBody() {
            return this.body;
        }
    }

    public static class InternalAdminRestClientException
    extends AdminRestClientException {
        private static final long serialVersionUID = -7945306952585650400L;

        public InternalAdminRestClientException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class AdminRestClientException
    extends Exception {
        private static final long serialVersionUID = -3479118087809884898L;

        public AdminRestClientException(String message) {
            super(message);
        }

        public AdminRestClientException(Throwable throwable) {
            super(throwable);
        }
    }
}

