/*
 * Decompiled with CFR 0.152.
 */
package com.cyphercor.logintc;

import com.cyphercor.logintc.AdminRestClient;
import com.cyphercor.logintc.JsonHelper;
import com.cyphercor.logintc.LoginTCCommon;
import com.cyphercor.logintc.resource.AsyncJob;
import com.cyphercor.logintc.resource.BypassCode;
import com.cyphercor.logintc.resource.Domain;
import com.cyphercor.logintc.resource.HardwareToken;
import com.cyphercor.logintc.resource.Organization;
import com.cyphercor.logintc.resource.Session;
import com.cyphercor.logintc.resource.Token;
import com.cyphercor.logintc.resource.User;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginTC
extends LoginTCCommon {
    private static final String USER_AGENT = String.format("%s/%s", "LoginTC-Java", LoginTC.class.getPackage().getImplementationVersion());
    protected LoginTCExceptionFactory exceptionFactory = new LoginTCExceptionFactory();

    public LoginTC(String apiKey) {
        this(apiKey, "cloud.logintc.com", true);
    }

    public LoginTC(String apiKey, String host) {
        this(apiKey, host, true);
    }

    public LoginTC(String apiKey, String host, Boolean secure) {
        this(apiKey, host, secure, null);
    }

    public LoginTC(String apiKey, String host, Boolean secure, AdminRestClient adminRestClient) {
        super(adminRestClient, apiKey, host, secure, USER_AGENT);
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.adminRestClient.setProxy(proxyHost, proxyPort);
    }

    public void setProxy(String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.adminRestClient.setProxy(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public User getUser(String userId) throws LoginTCException {
        User user = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/users/%s", userId)));
            JSONArray jsonDomains = jsonObject.getJSONArray("domains");
            ArrayList<String> domains = new ArrayList<String>();
            for (int i = 0; i < jsonDomains.length(); ++i) {
                domains.add(jsonDomains.getString(i));
            }
            ArrayList<String> bypassCodes = new ArrayList<String>();
            if (jsonObject.has("bypasscodes")) {
                JSONArray jsonBypassCodes = jsonObject.getJSONArray("bypasscodes");
                for (int i = 0; i < jsonBypassCodes.length(); ++i) {
                    bypassCodes.add(jsonBypassCodes.getString(i));
                }
            }
            String id = jsonObject.getString("id");
            String username = jsonObject.getString("username");
            String email = jsonObject.getString("email");
            String name = jsonObject.getString("name");
            String hardware = jsonObject.getString("hardware");
            user = new User(id, username, email, name, domains, bypassCodes, hardware);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return user;
    }

    public User getUserByUsername(String username) throws LoginTCException {
        User user = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/users", new Object[0]), String.format("username=%s", username)));
            JSONArray jsonDomains = jsonObject.getJSONArray("domains");
            ArrayList<String> domains = new ArrayList<String>();
            for (int i = 0; i < jsonDomains.length(); ++i) {
                domains.add(jsonDomains.getString(i));
            }
            ArrayList<String> bypassCodes = new ArrayList<String>();
            if (jsonObject.has("bypasscodes")) {
                JSONArray jsonBypassCodes = jsonObject.getJSONArray("bypasscodes");
                for (int i = 0; i < jsonBypassCodes.length(); ++i) {
                    bypassCodes.add(jsonBypassCodes.getString(i));
                }
            }
            String id = jsonObject.getString("id");
            String userUsername = jsonObject.getString("username");
            String email = jsonObject.getString("email");
            String name = jsonObject.getString("name");
            String hardware = jsonObject.getString("hardware");
            user = new User(id, userUsername, email, name, domains, bypassCodes, hardware);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return user;
    }

    public List<User> getUsers() throws LoginTCException {
        return this.getUsers(1);
    }

    public List<User> getUsers(Integer page) throws LoginTCException {
        ArrayList<User> users = new ArrayList<User>();
        try {
            JSONArray jsonArray = JsonHelper.getJsonArray(this.adminRestClient.get(String.format("/api/users", new Object[0]), String.format("page=%d", page)));
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject userObject = jsonArray.getJSONObject(i);
                JSONArray jsonDomains = userObject.getJSONArray("domains");
                ArrayList<String> domains = new ArrayList<String>();
                for (int j = 0; j < jsonDomains.length(); ++j) {
                    domains.add(jsonDomains.getString(j));
                }
                ArrayList<String> bypassCodes = new ArrayList<String>();
                if (userObject.has("bypasscodes")) {
                    JSONArray jsonBypassCodes = userObject.getJSONArray("bypasscodes");
                    for (int k = 0; k < jsonBypassCodes.length(); ++k) {
                        bypassCodes.add(jsonBypassCodes.getString(k));
                    }
                }
                String id = userObject.getString("id");
                String username = userObject.getString("username");
                String email = userObject.getString("email");
                String name = userObject.getString("name");
                String hardware = userObject.getString("hardware");
                users.add(new User(id, username, email, name, domains, bypassCodes, hardware));
            }
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return users;
    }

    public User createUser(String username, String email, String name) throws LoginTCException {
        User user = null;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("username", username);
            jsonObject.put("email", email);
            jsonObject.put("name", name);
            jsonObject = JsonHelper.getJson(this.adminRestClient.post("/api/users", jsonObject.toString()));
            JSONArray jsonDomains = jsonObject.getJSONArray("domains");
            ArrayList<String> domains = new ArrayList<String>();
            for (int i = 0; i < jsonDomains.length(); ++i) {
                domains.add(jsonDomains.getString(i));
            }
            ArrayList<String> bypassCodes = new ArrayList<String>();
            if (jsonObject.has("bypasscodes")) {
                JSONArray jsonBypassCodes = jsonObject.getJSONArray("bypasscodes");
                for (int i = 0; i < jsonBypassCodes.length(); ++i) {
                    bypassCodes.add(jsonBypassCodes.getString(i));
                }
            }
            String id = jsonObject.getString("id");
            username = jsonObject.getString("username");
            email = jsonObject.getString("email");
            name = jsonObject.getString("name");
            String hardware = jsonObject.getString("hardware");
            user = new User(id, username, email, name, domains, bypassCodes, hardware);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return user;
    }

    public User updateUser(String userId, String email, String name) throws LoginTCException {
        User user = null;
        try {
            JSONObject jsonObject = new JSONObject();
            if (email != null) {
                jsonObject.put("email", email);
            }
            if (name != null) {
                jsonObject.put("name", name);
            }
            jsonObject = JsonHelper.getJson(this.adminRestClient.put(String.format("/api/users/%s", userId), jsonObject.toString()));
            JSONArray jsonDomains = jsonObject.getJSONArray("domains");
            ArrayList<String> domains = new ArrayList<String>();
            for (int i = 0; i < jsonDomains.length(); ++i) {
                domains.add(jsonDomains.getString(i));
            }
            ArrayList<String> bypassCodes = new ArrayList<String>();
            if (jsonObject.has("bypasscodes")) {
                JSONArray jsonBypassCodes = jsonObject.getJSONArray("bypasscodes");
                for (int i = 0; i < jsonBypassCodes.length(); ++i) {
                    bypassCodes.add(jsonBypassCodes.getString(i));
                }
            }
            String id = jsonObject.getString("id");
            String username = jsonObject.getString("username");
            email = jsonObject.getString("email");
            name = jsonObject.getString("name");
            String hardware = jsonObject.getString("hardware");
            user = new User(id, username, email, name, domains, bypassCodes, hardware);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return user;
    }

    public void deleteUser(String userId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/users/%s", userId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public void addDomainUser(String domainId, String userId) throws LoginTCException {
        try {
            this.adminRestClient.put(String.format("/api/domains/%s/users/%s", domainId, userId), null);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public void setDomainUsers(String domainId, List<User> users) throws LoginTCException {
        try {
            JSONArray jsonArray = new JSONArray();
            for (User user : users) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("username", user.getUsername());
                jsonObject.put("email", user.getEmail());
                jsonObject.put("name", user.getName());
                jsonArray.put(jsonObject);
            }
            this.adminRestClient.put(String.format("/api/domains/%s/users", domainId), jsonArray.toString());
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public AsyncJob syncDomainUsers(String domainId, List<User> users, Domain.SyncMode syncMode, Domain.SyncTokenMode syncTokenMode, Integer maxRemoveLimit, String email, String groupName) throws LoginTCException {
        AsyncJob asyncJob = null;
        try {
            if (syncMode == null) {
                syncMode = Domain.SyncMode.ADD_ONLY;
            }
            if (syncTokenMode == null) {
                syncTokenMode = Domain.SyncTokenMode.DO_NOT_ISSUE_TOKEN;
            }
            if (maxRemoveLimit == null) {
                maxRemoveLimit = 0;
            }
            JSONObject jsonArgs = new JSONObject();
            JSONArray userArr = new JSONArray();
            for (User user : users) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("username", user.getUsername());
                jsonObject.put("email", user.getEmail());
                jsonObject.put("name", user.getName());
                if (user.getAlias1() != null) {
                    jsonObject.put("alias1", user.getAlias1());
                }
                if (user.getAlias2() != null) {
                    jsonObject.put("alias2", user.getAlias2());
                }
                if (user.getAlias3() != null) {
                    jsonObject.put("alias3", user.getAlias3());
                }
                if (user.getPhone() != null) {
                    JSONArray phoneArr = new JSONArray();
                    JSONObject phone = new JSONObject();
                    phone.put("number", user.getPhone());
                    phoneArr.put(phone);
                    jsonObject.put("phones", phoneArr);
                }
                userArr.put(jsonObject);
            }
            jsonArgs.put("users", userArr);
            jsonArgs.put("syncMode", syncMode.toString());
            jsonArgs.put("syncTokenMode", syncTokenMode.toString());
            jsonArgs.put("maxRemoveLimit", maxRemoveLimit);
            if (email != null) {
                jsonArgs.put("email", email);
            }
            if (groupName != null) {
                jsonArgs.put("groupName", groupName);
            }
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.put(String.format("/api/domains/%s/users/sync", domainId), jsonArgs.toString()));
            asyncJob = AsyncJob.getAsyncJobFromJSONObject(jsonObject);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (ParseException e) {
            throw this.exceptionFactory.createException(e);
        }
        return asyncJob;
    }

    public void removeDomainUser(String domainId, String userId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/domains/%s/users/%s", domainId, userId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public Token createUserToken(String domainId, String userId) throws LoginTCException {
        Token token = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.put(String.format("/api/domains/%s/users/%s/token", domainId, userId), null));
            Token.State state = Token.State.valueOf(jsonObject.getString("state").toUpperCase(Locale.ENGLISH));
            String code = jsonObject.has("code") ? jsonObject.getString("code") : null;
            token = new Token(state, code);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return token;
    }

    public Token getUserToken(String domainId, String userId) throws LoginTCException {
        Token token = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/domains/%s/users/%s/token", domainId, userId)));
            Token.State state = Token.State.valueOf(jsonObject.getString("state").toUpperCase(Locale.ENGLISH));
            String code = jsonObject.has("code") ? jsonObject.getString("code") : null;
            token = new Token(state, code);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return token;
    }

    public void deleteUserToken(String domainId, String userId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/domains/%s/users/%s/token", domainId, userId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public Session createSession(String domainId, String userId, Map<String, String> attributes) throws NoTokenLoginTCException, LoginTCException {
        return this.createSession(domainId, userId, attributes, null, null, null);
    }

    public Session createSession(String domainId, String userId, Map<String, String> attributes, String ipAddress, String bypassCode, String otp) throws NoTokenLoginTCException, LoginTCException {
        Session session = null;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONArray attributesArray = new JSONArray();
            if (attributes != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    JSONObject attributeObject = new JSONObject();
                    attributeObject.put("key", entry.getKey());
                    attributeObject.put("value", entry.getValue());
                    attributesArray.put(attributeObject);
                }
            }
            JSONObject jsonUserObject = new JSONObject();
            jsonUserObject.put("id", userId);
            jsonObject.put("user", jsonUserObject);
            jsonObject.put("attributes", attributesArray);
            if (ipAddress != null && !ipAddress.isEmpty()) {
                jsonObject.put("ipAddress", ipAddress);
            }
            if (bypassCode != null) {
                jsonObject.put("bypasscode", bypassCode);
            } else if (otp != null) {
                jsonObject.put("otp", otp);
            }
            jsonObject = JsonHelper.getJson(this.adminRestClient.post(String.format("/api/domains/%s/sessions", domainId), jsonObject.toString()));
            String id = jsonObject.getString("id");
            Session.State state = Session.State.valueOf(jsonObject.getString("state").toUpperCase(Locale.ENGLISH));
            session = new Session(id, state);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return session;
    }

    public Session createSessionWithUsername(String domainId, String username, Map<String, String> attributes) throws NoTokenLoginTCException, LoginTCException {
        return this.createSessionWithUsername(domainId, username, attributes, null, null, null);
    }

    public Session createSessionWithUsername(String domainId, String username, Map<String, String> attributes, String ipAddress, String bypassCode, String otp) throws NoTokenLoginTCException, LoginTCException {
        Session session = null;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONArray attributesArray = new JSONArray();
            if (attributes != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    JSONObject attributeObject = new JSONObject();
                    attributeObject.put("key", entry.getKey());
                    attributeObject.put("value", entry.getValue());
                    attributesArray.put(attributeObject);
                }
            }
            JSONObject jsonUserObject = new JSONObject();
            jsonUserObject.put("username", username);
            jsonObject.put("user", jsonUserObject);
            jsonObject.put("attributes", attributesArray);
            if (ipAddress != null && !ipAddress.isEmpty()) {
                jsonObject.put("ipAddress", ipAddress);
            }
            if (bypassCode != null && !bypassCode.isEmpty()) {
                jsonObject.put("bypasscode", bypassCode);
            } else if (otp != null && !otp.isEmpty()) {
                jsonObject.put("otp", otp);
            }
            jsonObject = JsonHelper.getJson(this.adminRestClient.post(String.format("/api/domains/%s/sessions", domainId), jsonObject.toString()));
            String id = jsonObject.getString("id");
            Session.State state = Session.State.valueOf(jsonObject.getString("state").toUpperCase(Locale.ENGLISH));
            session = new Session(id, state);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return session;
    }

    public Session getSession(String domainId, String sessionId) throws NoTokenLoginTCException, LoginTCException {
        Session session = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/domains/%s/sessions/%s", domainId, sessionId)));
            Session.State state = Session.State.valueOf(jsonObject.getString("state").toUpperCase(Locale.ENGLISH));
            session = new Session(sessionId, state);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return session;
    }

    public void deleteSession(String domainId, String sessionId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/domains/%s/sessions/%s", domainId, sessionId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public boolean getPing() throws LoginTCException {
        boolean status = false;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get("/api/ping"));
            if (jsonObject.getString("status").equals("OK")) {
                status = true;
            }
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return status;
    }

    public Organization getOrganization() throws LoginTCException {
        Organization organization = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get("/api/organization"));
            String organizationName = jsonObject.getString("name");
            organization = new Organization(organizationName);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return organization;
    }

    public Domain getDomain(String domainId) throws LoginTCException {
        Domain domain = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/domains/%s", domainId)));
            String id = jsonObject.getString("id");
            String name = jsonObject.getString("name");
            String type = jsonObject.getString("type");
            String keyType = jsonObject.getString("keyType");
            Integer maxAllowedRetries = jsonObject.getInt("maxAllowedRetries");
            Integer requestTimeout = jsonObject.getInt("requestTimeout");
            Integer activationCodeExpiration = jsonObject.getInt("activationCodeExpiration");
            Boolean requestPollingEnabled = jsonObject.getBoolean("requestPollingEnabled");
            Boolean bypassEnabled = jsonObject.getBoolean("bypassEnabled");
            domain = new Domain(id, name, type, keyType, maxAllowedRetries, requestTimeout, activationCodeExpiration, requestPollingEnabled, bypassEnabled);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return domain;
    }

    public byte[] getDomainImage(String domainId) throws LoginTCException {
        byte[] image = null;
        try {
            image = this.adminRestClient.getBytes(String.format("/api/domains/%s/image", domainId), "image/png");
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return image;
    }

    public User getDomainUser(String domainId, String userId) throws LoginTCException {
        User user = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/domains/%s/users/%s", domainId, userId)));
            JSONArray jsonDomains = jsonObject.getJSONArray("domains");
            ArrayList<String> domains = new ArrayList<String>();
            for (int i = 0; i < jsonDomains.length(); ++i) {
                domains.add(jsonDomains.getString(i));
            }
            ArrayList<String> bypassCodes = new ArrayList<String>();
            if (jsonObject.has("bypasscodes")) {
                JSONArray jsonBypassCodes = jsonObject.getJSONArray("bypasscodes");
                for (int i = 0; i < jsonBypassCodes.length(); ++i) {
                    bypassCodes.add(jsonBypassCodes.getString(i));
                }
            }
            String id = jsonObject.getString("id");
            String username = jsonObject.getString("username");
            String email = jsonObject.getString("email");
            String name = jsonObject.getString("name");
            String hardware = jsonObject.getString("hardware");
            user = new User(id, username, email, name, domains, bypassCodes, hardware);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return user;
    }

    public List<User> getDomainUsers(String domainId) throws LoginTCException {
        return this.getDomainUsers(domainId, 1);
    }

    public List<User> getDomainUsers(String domainId, Integer page) throws LoginTCException {
        ArrayList<User> users = new ArrayList<User>();
        try {
            JSONArray jsonArray = JsonHelper.getJsonArray(this.adminRestClient.get(String.format("/api/domains/%s/users", domainId), String.format("page=%d", page)));
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject userObject = jsonArray.getJSONObject(i);
                JSONArray jsonDomains = userObject.getJSONArray("domains");
                ArrayList<String> domains = new ArrayList<String>();
                for (int j = 0; j < jsonDomains.length(); ++j) {
                    domains.add(jsonDomains.getString(j));
                }
                ArrayList<String> bypassCodes = new ArrayList<String>();
                if (userObject.has("bypasscodes")) {
                    JSONArray jsonBypassCodes = userObject.getJSONArray("bypasscodes");
                    for (int k = 0; k < jsonBypassCodes.length(); ++k) {
                        bypassCodes.add(jsonBypassCodes.getString(k));
                    }
                }
                String id = userObject.getString("id");
                String username = userObject.getString("username");
                String email = userObject.getString("email");
                String name = userObject.getString("name");
                String hardware = userObject.getString("hardware");
                users.add(new User(id, username, email, name, domains, bypassCodes, hardware));
            }
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return users;
    }

    public BypassCode getBypassCode(String bypassCodeId) throws LoginTCException {
        BypassCode bypassCode = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/bypasscodes/%s", bypassCodeId)));
            String id = jsonObject.getString("id");
            String code = jsonObject.getString("code");
            Date dtExpiry = DATE_FORMAT_ISO8601.parse(jsonObject.getString("dtExpiry"));
            String user = jsonObject.getString("user");
            Integer usesAllowed = jsonObject.getInt("usesAllowed");
            Integer usesRemaining = jsonObject.getInt("usesRemaining");
            bypassCode = new BypassCode(id, code, dtExpiry, user, usesAllowed, usesRemaining);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (ParseException e) {
            throw this.exceptionFactory.createException(e);
        }
        return bypassCode;
    }

    public List<BypassCode> getBypassCodes(String userId) throws LoginTCException {
        ArrayList<BypassCode> bypassCodes = new ArrayList<BypassCode>();
        try {
            JSONArray jsonArray = JsonHelper.getJsonArray(this.adminRestClient.get(String.format("/api/users/%s/bypasscodes", userId)));
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String id = jsonObject.getString("id");
                String code = jsonObject.getString("code");
                Date dtExpiry = DATE_FORMAT_ISO8601.parse(jsonObject.getString("dtExpiry"));
                String user = jsonObject.getString("user");
                Integer usesAllowed = jsonObject.getInt("usesAllowed");
                Integer usesRemaining = jsonObject.getInt("usesRemaining");
                bypassCodes.add(new BypassCode(id, code, dtExpiry, user, usesAllowed, usesRemaining));
            }
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (ParseException e) {
            throw this.exceptionFactory.createException(e);
        }
        return bypassCodes;
    }

    public BypassCode createBypassCode(String userId) throws LoginTCException {
        return this.createBypassCode(userId, null, null);
    }

    public BypassCode createBypassCode(String userId, Integer usesAllowed, Integer expirationTime) throws LoginTCException {
        BypassCode bypassCode = null;
        try {
            JSONObject jsonObject = new JSONObject();
            if (usesAllowed == null) {
                usesAllowed = 1;
            }
            if (expirationTime == null) {
                expirationTime = 0;
            }
            jsonObject.put("usesAllowed", usesAllowed);
            jsonObject.put("expirationTime", expirationTime);
            jsonObject = JsonHelper.getJson(this.adminRestClient.post(String.format("/api/users/%s/bypasscodes", userId), jsonObject.toString()));
            String id = jsonObject.getString("id");
            String code = jsonObject.getString("code");
            Date dtExpiry = DATE_FORMAT_ISO8601.parse(jsonObject.getString("dtExpiry"));
            String user = jsonObject.getString("user");
            usesAllowed = jsonObject.getInt("usesAllowed");
            Integer usesRemaining = jsonObject.getInt("usesRemaining");
            bypassCode = new BypassCode(id, code, dtExpiry, user, usesAllowed, usesRemaining);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (ParseException e) {
            throw this.exceptionFactory.createException(e);
        }
        return bypassCode;
    }

    public void deleteBypassCode(String bypassCodeId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/bypasscodes/%s", bypassCodeId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public void deleteBypassCodes(String userId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/users/%s/bypasscodes", userId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public HardwareToken getHardwareToken(String hardwareTokenId) throws LoginTCException {
        HardwareToken hardwareToken = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/hardware/%s", hardwareTokenId)));
            String id = jsonObject.getString("id");
            String alias = jsonObject.getString("alias");
            String serialNumber = jsonObject.getString("serialNumber");
            String type = jsonObject.getString("type");
            String timeStep = jsonObject.getString("timeStep");
            String syncState = jsonObject.getString("syncState");
            String user = jsonObject.getString("user");
            hardwareToken = new HardwareToken(id, alias, serialNumber, type, timeStep, syncState, user);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return hardwareToken;
    }

    public HardwareToken getUserHardwareToken(String userId) throws LoginTCException {
        HardwareToken hardwareToken = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/users/%s/hardware", userId)));
            String id = jsonObject.getString("id");
            String alias = jsonObject.getString("alias");
            String serialNumber = jsonObject.getString("serialNumber");
            String type = jsonObject.getString("type");
            String timeStep = jsonObject.getString("timeStep");
            String syncState = jsonObject.getString("syncState");
            String user = jsonObject.getString("user");
            hardwareToken = new HardwareToken(id, alias, serialNumber, type, timeStep, syncState, user);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return hardwareToken;
    }

    public List<HardwareToken> getHardwareTokens() throws LoginTCException {
        return this.getHardwareTokens(1);
    }

    public List<HardwareToken> getHardwareTokens(Integer page) throws LoginTCException {
        ArrayList<HardwareToken> hardwareTokens = new ArrayList<HardwareToken>();
        try {
            JSONArray jsonArray = JsonHelper.getJsonArray(this.adminRestClient.get(String.format("/api/hardware", new Object[0]), String.format("page=%d", page)));
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject hardwareTokenObject = jsonArray.getJSONObject(i);
                String id = hardwareTokenObject.getString("id");
                String alias = hardwareTokenObject.getString("alias");
                String serialNumber = hardwareTokenObject.getString("serialNumber");
                String type = hardwareTokenObject.getString("type");
                String timeStep = hardwareTokenObject.getString("timeStep");
                String syncState = hardwareTokenObject.getString("syncState");
                String user = hardwareTokenObject.getString("user");
                hardwareTokens.add(new HardwareToken(id, alias, serialNumber, type, timeStep, syncState, user));
            }
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return hardwareTokens;
    }

    public HardwareToken createHardwareToken(String alias, String serialNumber, String type, String timeStep, String seed) throws LoginTCException {
        HardwareToken hardwareToken = null;
        try {
            JSONObject jsonObject = new JSONObject();
            if (alias != null) {
                jsonObject.put("alias", alias);
            }
            jsonObject.put("serialNumber", serialNumber);
            jsonObject.put("type", type);
            jsonObject.put("timeStep", timeStep);
            jsonObject.put("seed", seed);
            jsonObject = JsonHelper.getJson(this.adminRestClient.post(String.format("/api/hardware", new Object[0]), jsonObject.toString()));
            String id = jsonObject.getString("id");
            alias = jsonObject.getString("alias");
            serialNumber = jsonObject.getString("serialNumber");
            type = jsonObject.getString("type");
            timeStep = jsonObject.getString("timeStep");
            String syncState = jsonObject.getString("syncState");
            String user = jsonObject.getString("user");
            hardwareToken = new HardwareToken(id, alias, serialNumber, type, timeStep, syncState, user);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return hardwareToken;
    }

    public HardwareToken updateHardwareToken(String hardwareTokenId, String alias) throws LoginTCException {
        HardwareToken hardwareToken = null;
        try {
            JSONObject jsonObject = new JSONObject();
            if (alias != null) {
                jsonObject.put("alias", alias);
            }
            jsonObject = JsonHelper.getJson(this.adminRestClient.put(String.format("/api/hardware/%s", hardwareTokenId), jsonObject.toString()));
            String id = jsonObject.getString("id");
            alias = jsonObject.getString("alias");
            String serialNumber = jsonObject.getString("serialNumber");
            String type = jsonObject.getString("type");
            String timeStep = jsonObject.getString("timeStep");
            String syncState = jsonObject.getString("syncState");
            String user = jsonObject.getString("user");
            hardwareToken = new HardwareToken(id, alias, serialNumber, type, timeStep, syncState, user);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        return hardwareToken;
    }

    public void deleteHardwareToken(String hardwareTokenId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/hardware/%s", hardwareTokenId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public void associateHardwareToken(String userId, String hardwareTokenId) throws LoginTCException {
        try {
            this.adminRestClient.put(String.format("/api/users/%s/hardware/%s", userId, hardwareTokenId), null);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public void disassociateHardwareToken(String userId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/users/%s/hardware", userId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public AsyncJob getAsyncJob(String asyncJobId) throws LoginTCException {
        AsyncJob asyncJob = null;
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/jobs/%s", asyncJobId)));
            asyncJob = AsyncJob.getAsyncJobFromJSONObject(jsonObject);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (ParseException e) {
            throw this.exceptionFactory.createException(e);
        }
        return asyncJob;
    }

    public void createDeliverableOTP(String domainId, String userId, String localeStr, Session.DeliverableOTPType deliverableOTPType) throws LoginTCException {
        this.createDeliverableOTP(domainId, userId, localeStr, deliverableOTPType, null);
    }

    public void createDeliverableOTP(String domainId, String userId, String localeStr, Session.DeliverableOTPType deliverableOTPType, String deviceId) throws LoginTCException {
        if ((deliverableOTPType == Session.DeliverableOTPType.SMS || deliverableOTPType == Session.DeliverableOTPType.PHONE_CALL) && deviceId == null) {
            throw new IllegalArgumentException("deviceId must be specified when sending an OTP by SMS or phone call.");
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("localeStr", localeStr);
            jsonObject.put("deliverableOTPType", deliverableOTPType.toString());
            if (deviceId != null) {
                jsonObject.put("deviceId", deviceId);
            }
            this.adminRestClient.post(String.format("/api/domains/%s/users/%s/otp", domainId, userId), jsonObject.toString());
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    class LoginTCExceptionFactory {
        LoginTCExceptionFactory() {
        }

        public LoginTCException createException(AdminRestClient.RestAdminRestClientException restAdminClientException) {
            LoginTCException exception = new InternalLoginTCException((Throwable)restAdminClientException);
            try {
                JSONObject jsonObject = JsonHelper.getJson(restAdminClientException.getBody());
                JSONArray errorsArray = jsonObject.getJSONArray("errors");
                JSONObject jsonError = errorsArray.getJSONObject(0);
                String errorCode = jsonError.getString("code");
                String errorMessage = jsonError.getString("message");
                exception = errorCode.equals("api.error.notfound.token") ? new NoTokenLoginTCException(errorCode, errorMessage) : new ApiLoginTCException(errorCode, errorMessage);
            }
            catch (JSONException e) {
                return exception;
            }
            return exception;
        }

        public LoginTCException createException(AdminRestClient.AdminRestClientException e) {
            return new InternalLoginTCException((Throwable)e);
        }

        public LoginTCException createException(JSONException e) {
            return new InternalLoginTCException((Throwable)e);
        }

        public LoginTCException createException(ParseException e) {
            return new InternalLoginTCException((Throwable)e);
        }
    }

    public class NoTokenLoginTCException
    extends ApiLoginTCException {
        private static final long serialVersionUID = -5878018652693276417L;

        public NoTokenLoginTCException(String errorCode, String errorMessage) {
            super(errorCode, errorMessage);
        }
    }

    public class InternalLoginTCException
    extends LoginTCException {
        private static final long serialVersionUID = -7310070273601778377L;

        public InternalLoginTCException(Throwable throwable) {
            super(throwable);
        }
    }

    public class ApiLoginTCException
    extends LoginTCException {
        private static final long serialVersionUID = 2957085008596633695L;
        private String errorCode;
        private String errorMessage;

        public ApiLoginTCException(String errorCode, String errorMessage) {
            super(String.format("%s: %s", errorCode, errorMessage));
            this.errorCode = null;
            this.errorMessage = null;
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public class LoginTCException
    extends Exception {
        private static final long serialVersionUID = 3112741136967467568L;

        public LoginTCException(String message) {
            super(message);
        }

        public LoginTCException(Throwable throwable) {
            super(throwable);
        }

        public LoginTCException() {
        }
    }
}

