/*
 * Decompiled with CFR 0.152.
 */
package com.cyphercor.logintc;

import com.cyphercor.logintc.AdminRestClient;
import com.cyphercor.logintc.JsonHelper;
import com.cyphercor.logintc.LoginTCCommon;
import com.cyphercor.logintc.resource.Application;
import com.cyphercor.logintc.resource.Session;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginTCApplication
extends LoginTCCommon {
    private static final String USER_AGENT = String.format("%s/%s", "LoginTC-Java", LoginTCApplication.class.getPackage().getImplementationVersion());
    protected LoginTCExceptionFactory exceptionFactory = new LoginTCExceptionFactory();

    public LoginTCApplication(String apiKey) {
        this(apiKey, "cloud.logintc.com", true);
    }

    public LoginTCApplication(String apiKey, String host) {
        this(apiKey, host, true);
    }

    public LoginTCApplication(String apiKey, String host, Boolean secure) {
        this(apiKey, host, secure, null);
    }

    public LoginTCApplication(String apiKey, String host, Boolean secure, AdminRestClient adminRestClient) {
        super(adminRestClient, apiKey, host, secure, USER_AGENT);
    }

    public Application getApplication(String applicationId) throws LoginTCException {
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/applications/%s", applicationId)));
            String id = jsonObject.getString("id");
            String name = jsonObject.getString("name");
            String type = jsonObject.getString("type");
            String domainId = jsonObject.getString("domainId");
            return new Application(id, name, type, domainId);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public Session createSession(String applicationId, String userId, Map<String, String> attributes, String localeStr) throws NoTokenLoginTCException, LoginTCException {
        return this.createSession(applicationId, userId, attributes, null, null, null, localeStr);
    }

    public Session createSession(String applicationId, String userId, Map<String, String> attributes, String ipAddress, String bypassCode, String otp, String localeStr) throws NoTokenLoginTCException, LoginTCException {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONArray attributesArray = new JSONArray();
            if (attributes != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    JSONObject attributeObject = new JSONObject();
                    attributeObject.put("key", entry.getKey());
                    attributeObject.put("value", entry.getValue());
                    attributesArray.put(attributeObject);
                }
            }
            JSONObject jsonUserObject = new JSONObject();
            jsonUserObject.put("id", userId);
            jsonObject.put("user", jsonUserObject);
            jsonObject.put("attributes", attributesArray);
            if (ipAddress != null && !ipAddress.isEmpty()) {
                jsonObject.put("ipAddress", ipAddress);
            }
            if (bypassCode != null) {
                jsonObject.put("bypasscode", bypassCode);
            } else if (otp != null) {
                jsonObject.put("otp", otp);
            }
            if (localeStr != null) {
                jsonObject.put("localeStr", localeStr);
            }
            jsonObject = JsonHelper.getJson(this.adminRestClient.post(String.format("/api/applications/%s/sessions", applicationId), jsonObject.toString()));
            String id = jsonObject.getString("id");
            Session.State state = Session.State.valueOf(jsonObject.getString("state").toUpperCase(Locale.ENGLISH));
            return new Session(id, state);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public Session createSessionWithUsername(String applicationId, String username, Map<String, String> attributes, String localeStr) throws NoTokenLoginTCException, LoginTCException {
        return this.createSessionWithUsername(applicationId, username, attributes, null, null, null, localeStr);
    }

    public Session createSessionWithUsername(String applicationId, String username, Map<String, String> attributes, String ipAddress, String bypassCode, String otp, String localeStr) throws NoTokenLoginTCException, LoginTCException {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONArray attributesArray = new JSONArray();
            if (attributes != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    JSONObject attributeObject = new JSONObject();
                    attributeObject.put("key", entry.getKey());
                    attributeObject.put("value", entry.getValue());
                    attributesArray.put(attributeObject);
                }
            }
            JSONObject jsonUserObject = new JSONObject();
            jsonUserObject.put("username", username);
            jsonObject.put("user", jsonUserObject);
            jsonObject.put("attributes", attributesArray);
            if (ipAddress != null && !ipAddress.isEmpty()) {
                jsonObject.put("ipAddress", ipAddress);
            }
            if (bypassCode != null && !bypassCode.isEmpty()) {
                jsonObject.put("bypasscode", bypassCode);
            } else if (otp != null && !otp.isEmpty()) {
                jsonObject.put("otp", otp);
            }
            if (localeStr != null) {
                jsonObject.put("localeStr", localeStr);
            }
            jsonObject = JsonHelper.getJson(this.adminRestClient.post(String.format("/api/applications/%s/sessions", applicationId), jsonObject.toString()));
            String id = jsonObject.getString("id");
            Session.State state = Session.State.valueOf(jsonObject.getString("state").toUpperCase(Locale.ENGLISH));
            return new Session(id, state);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public Session getSession(String applicationId, String sessionId) throws NoTokenLoginTCException, LoginTCException {
        try {
            JSONObject jsonObject = JsonHelper.getJson(this.adminRestClient.get(String.format("/api/applications/%s/sessions/%s", applicationId, sessionId)));
            Session.State state = Session.State.valueOf(jsonObject.getString("state").toUpperCase(Locale.ENGLISH));
            return new Session(sessionId, state);
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public void deleteSession(String applicationId, String sessionId) throws LoginTCException {
        try {
            this.adminRestClient.delete(String.format("/api/applications/%s/sessions/%s", applicationId, sessionId));
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    public void createDeliverableOTP(String applicationId, String userId, String localeStr, Session.DeliverableOTPType deliverableOTPType, String deviceId) throws LoginTCException {
        if ((deliverableOTPType == Session.DeliverableOTPType.SMS || deliverableOTPType == Session.DeliverableOTPType.PHONE_CALL) && deviceId == null) {
            throw new IllegalArgumentException("deviceId must be specified when sending an OTP by SMS or phone call.");
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("localeStr", localeStr);
            jsonObject.put("deliverableOTPType", deliverableOTPType.toString());
            if (deviceId != null) {
                jsonObject.put("deviceId", deviceId);
            }
            this.adminRestClient.post(String.format("/api/applications/%s/users/%s/otp", applicationId, userId), jsonObject.toString());
        }
        catch (JSONException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.RestAdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
        catch (AdminRestClient.AdminRestClientException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    class LoginTCExceptionFactory {
        LoginTCExceptionFactory() {
        }

        public LoginTCException createException(AdminRestClient.RestAdminRestClientException restAdminClientException) {
            LoginTCException exception = new InternalLoginTCException((Throwable)restAdminClientException);
            try {
                JSONObject jsonObject = JsonHelper.getJson(restAdminClientException.getBody());
                JSONArray errorsArray = jsonObject.getJSONArray("errors");
                JSONObject jsonError = errorsArray.getJSONObject(0);
                String errorCode = jsonError.getString("code");
                String errorMessage = jsonError.getString("message");
                exception = errorCode.equals("api.error.notfound.token") ? new NoTokenLoginTCException(errorCode, errorMessage) : new ApiLoginTCException(errorCode, errorMessage);
            }
            catch (JSONException e) {
                return exception;
            }
            return exception;
        }

        public LoginTCException createException(AdminRestClient.AdminRestClientException e) {
            return new InternalLoginTCException((Throwable)e);
        }

        public LoginTCException createException(JSONException e) {
            return new InternalLoginTCException((Throwable)e);
        }

        public LoginTCException createException(ParseException e) {
            return new InternalLoginTCException((Throwable)e);
        }
    }

    public class NoTokenLoginTCException
    extends ApiLoginTCException {
        private static final long serialVersionUID = -5878018652693276417L;

        public NoTokenLoginTCException(String errorCode, String errorMessage) {
            super(errorCode, errorMessage);
        }
    }

    public class InternalLoginTCException
    extends LoginTCException {
        private static final long serialVersionUID = -7310070273601778377L;

        public InternalLoginTCException(Throwable throwable) {
            super(throwable);
        }
    }

    public class ApiLoginTCException
    extends LoginTCException {
        private static final long serialVersionUID = 2957085008596633695L;
        private String errorCode;
        private String errorMessage;

        public ApiLoginTCException(String errorCode, String errorMessage) {
            super(String.format("%s: %s", errorCode, errorMessage));
            this.errorCode = null;
            this.errorMessage = null;
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public class LoginTCException
    extends Exception {
        private static final long serialVersionUID = 3112741136967467568L;

        public LoginTCException(String message) {
            super(message);
        }

        public LoginTCException(Throwable throwable) {
            super(throwable);
        }

        public LoginTCException() {
        }
    }
}

