/*
 * Decompiled with CFR 0.152.
 */
package com.cyphercor.logintc.resource;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class AsyncJob {
    private static final SimpleDateFormat DATE_FORMAT_ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private String id = null;
    private AsyncJobType type = null;
    private AsyncJobStatus status = null;
    private String errorCode = null;
    private String errorMessage = null;
    private Integer totalActions = null;
    private Integer completedActions = null;
    private Date dtCreated = null;
    private Date dtStarted = null;
    private Date dtCompleted = null;

    public AsyncJob(String id, AsyncJobType type, AsyncJobStatus status, String errorCode, String errorMessage, Integer totalActions, Integer completedActions, Date dtCreated, Date dtStarted, Date dtCompleted) {
        this.id = id;
        this.type = type;
        this.status = status;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.totalActions = totalActions;
        this.completedActions = completedActions;
        this.dtCreated = dtCreated;
        this.dtStarted = dtStarted;
        this.dtCompleted = dtCompleted;
    }

    public static AsyncJob getAsyncJobFromJSONObject(JSONObject jsonObject) throws JSONException, ParseException {
        String id = jsonObject.getString("id");
        AsyncJobType type = AsyncJobType.fromString(jsonObject.getString("type"));
        AsyncJobStatus status = AsyncJobStatus.fromString(jsonObject.getString("status"));
        String errorCode = null;
        String errorMessage = null;
        Integer totalActions = null;
        Integer completedActions = null;
        Date dtCreated = null;
        Date dtStarted = null;
        Date dtCompleted = null;
        if (jsonObject.has("errorCode")) {
            errorCode = jsonObject.getString("errorCode");
        }
        if (jsonObject.has("errorMessage")) {
            errorMessage = jsonObject.getString("errorMessage");
        }
        if (jsonObject.has("totalActions")) {
            totalActions = jsonObject.getInt("totalActions");
        }
        if (jsonObject.has("completedActions")) {
            completedActions = jsonObject.getInt("completedActions");
        }
        if (jsonObject.has("dtCreated")) {
            dtCreated = DATE_FORMAT_ISO8601.parse(jsonObject.getString("dtCreated"));
        }
        if (jsonObject.has("dtStarted")) {
            dtStarted = DATE_FORMAT_ISO8601.parse(jsonObject.getString("dtStarted"));
        }
        if (jsonObject.has("dtCompleted")) {
            dtCompleted = DATE_FORMAT_ISO8601.parse(jsonObject.getString("dtCompleted"));
        }
        return new AsyncJob(id, type, status, errorCode, errorMessage, totalActions, completedActions, dtCreated, dtStarted, dtCompleted);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AsyncJobType getType() {
        return this.type;
    }

    public void setType(AsyncJobType type) {
        this.type = type;
    }

    public AsyncJobStatus getStatus() {
        return this.status;
    }

    public void setStatus(AsyncJobStatus status) {
        this.status = status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErorrMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Integer getTotalActions() {
        return this.totalActions;
    }

    public void setTotalActions(Integer totalActions) {
        this.totalActions = totalActions;
    }

    public Integer getCompletedActions() {
        return this.completedActions;
    }

    public void setCompletedActions(Integer completedActions) {
        this.completedActions = completedActions;
    }

    public Date getDtCreated() {
        return this.dtCreated;
    }

    public void setDtCreated(Date dtCreated) {
        this.dtCreated = dtCreated;
    }

    public Date getDtStarted() {
        return this.dtStarted;
    }

    public void setDtStarted(Date dtStarted) {
        this.dtStarted = dtStarted;
    }

    public Date getDtCompleted() {
        return this.dtCompleted;
    }

    public void setDtCompleted(Date dtCompleted) {
        this.dtCompleted = dtCompleted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AsyncJobStatus {
        COMPLETED,
        CREATED,
        IN_PROGRESS,
        FAILED;


        public static AsyncJobStatus fromString(String asyncJobStatus) {
            if (asyncJobStatus == null) {
                return null;
            }
            if (asyncJobStatus.equalsIgnoreCase("completed")) {
                return COMPLETED;
            }
            if (asyncJobStatus.equalsIgnoreCase("created")) {
                return CREATED;
            }
            if (asyncJobStatus.equalsIgnoreCase("in progress")) {
                return IN_PROGRESS;
            }
            if (asyncJobStatus.equalsIgnoreCase("failed")) {
                return FAILED;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case COMPLETED: {
                    return "Completed";
                }
                case CREATED: {
                    return "Created";
                }
                case IN_PROGRESS: {
                    return "In Progress";
                }
                case FAILED: {
                    return "Failed";
                }
            }
            return "Unknown";
        }

        public boolean isDone() {
            switch (this) {
                case COMPLETED: 
                case FAILED: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AsyncJobType {
        SyncUsersJob;


        public static AsyncJobType fromString(String asyncJobType) {
            if (asyncJobType == null) {
                return null;
            }
            if (asyncJobType.equalsIgnoreCase("syncusersjob")) {
                return SyncUsersJob;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case SyncUsersJob: {
                    return "SyncUsersJob";
                }
            }
            return "Unknown";
        }
    }
}

