/*
 * Decompiled with CFR 0.152.
 */
package com.cyphercor.logintc.sync;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesGcmEncryptor {
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 128;
    private static final int KEY_LENGTH = 32;
    private static final String KEY_FILE_NAME = "key.bin";
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private final SecretKey secretKey;

    private AesGcmEncryptor(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Key bytes cannot be null");
        }
        if (byArray.length != 32) {
            throw new IllegalArgumentException(String.format("Key length must be %d bytes but was %d bytes", 32, byArray.length));
        }
        this.secretKey = new SecretKeySpec(byArray, 0, byArray.length, "AES");
    }

    public String encrypt(String string) throws GeneralSecurityException {
        if (string == null) {
            throw new IllegalArgumentException("Plaintext cannot be null");
        }
        byte[] byArray = new byte[12];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray);
        cipher.init(1, (Key)this.secretKey, gCMParameterSpec);
        byte[] byArray2 = cipher.doFinal(string.getBytes(StandardCharsets.UTF_8));
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return Base64.getEncoder().encodeToString(byArray3);
    }

    public String decrypt(String string) throws GeneralSecurityException {
        byte[] byArray;
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("Encrypted value cannot be null or empty");
        }
        try {
            byArray = Base64.getDecoder().decode(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid Base64 encoding: " + illegalArgumentException.getMessage());
        }
        if (byArray.length <= 12) {
            throw new IllegalArgumentException(String.format("Encrypted value too short. Expected at least %d bytes, got %d bytes", 13, byArray.length));
        }
        byte[] byArray2 = new byte[12];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[byArray.length - 12];
        System.arraycopy(byArray, 12, byArray3, 0, byArray3.length);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray2);
        cipher.init(2, (Key)this.secretKey, gCMParameterSpec);
        byte[] byArray4 = cipher.doFinal(byArray3);
        return new String(byArray4, StandardCharsets.UTF_8);
    }

    public static AesGcmEncryptor getInstance() throws IOException {
        File file = new File(KEY_FILE_NAME);
        if (!file.exists()) {
            byte[] byArray = new byte[32];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(byArray);
            }
            file.setReadable(false, false);
            file.setReadable(true, true);
            file.setWritable(false, false);
            file.setWritable(true, true);
            file.setExecutable(false, false);
            System.err.println("INFO: Generated new encryption key: key.bin");
            System.err.println("IMPORTANT: Keep this file secure and backed up. It is required to decrypt configuration values.");
            return new AesGcmEncryptor(byArray);
        }
        byte[] byArray = Files.readAllBytes(file.toPath());
        if (byArray.length != 32) {
            throw new IOException(String.format("Invalid key file '%s'. Expected %d bytes, found %d bytes. The key file may be corrupted.", KEY_FILE_NAME, 32, byArray.length));
        }
        return new AesGcmEncryptor(byArray);
    }
}

