/*
 * Decompiled with CFR 0.152.
 */
package com.cyphercor.logintc.sync;

import com.cyphercor.logintc.resource.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;

public class LDAPWrapper {
    private static final int SEARCH_PAGE_SIZE = 100;
    private Encryption encryption = null;
    private String host = null;
    private String baseDN = null;
    private String bindDN = null;
    private String bindPassword = null;
    private String attrUsername = null;
    private String attrName = null;
    private String attrEmail = null;
    private String attrAlias1 = null;
    private String attrAlias2 = null;
    private String attrAlias3 = null;
    private String attrPhone = null;
    private String filter = null;
    private String defaultName = null;
    private String defaultEmail = null;
    private Boolean normalizeAttrAlias1 = false;
    private Boolean normalizeAttrAlias2 = false;
    private Boolean normalizeAttrAlias3 = false;

    public LDAPWrapper(Encryption encryption, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, Boolean bl, Boolean bl2, Boolean bl3) {
        this.encryption = encryption;
        this.host = string;
        this.baseDN = string2;
        this.bindDN = string3;
        this.bindPassword = string4;
        this.attrUsername = string5;
        this.attrName = string6;
        this.attrEmail = string7;
        this.attrAlias1 = string8;
        this.attrAlias2 = string9;
        this.attrAlias3 = string10;
        this.attrPhone = string11;
        this.filter = string12;
        this.defaultName = string13;
        this.defaultEmail = string14;
        this.normalizeAttrAlias1 = bl;
        this.normalizeAttrAlias2 = bl2;
        this.normalizeAttrAlias3 = bl3;
    }

    public List<User> fetchUsers(boolean bl) throws NamingException, IOException {
        Object object;
        ArrayList<User> arrayList = new ArrayList<User>();
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", String.format("%s://%s", this.encryption == Encryption.SSL ? "ldaps" : "ldap", this.host));
        if (bl) {
            properties.put("java.naming.referral", "follow");
        } else {
            properties.put("java.naming.referral", "ignore");
        }
        properties.put("java.naming.security.principal", this.bindDN);
        properties.put("java.naming.security.credentials", this.bindPassword);
        InitialLdapContext initialLdapContext = new InitialLdapContext(properties, null);
        StartTlsResponse startTlsResponse = null;
        if (this.encryption == Encryption.STARTTLS) {
            startTlsResponse = (StartTlsResponse)initialLdapContext.extendedOperation(new StartTlsRequest());
            startTlsResponse.negotiate();
            initialLdapContext.addToEnvironment("java.naming.security.principal", this.bindDN);
            initialLdapContext.addToEnvironment("java.naming.security.credentials", this.bindPassword);
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(this.attrUsername);
        arrayList2.add(this.attrEmail);
        arrayList2.add(this.attrName);
        if (this.attrAlias1 != null) {
            arrayList2.add(this.attrAlias1);
        }
        if (this.attrAlias2 != null) {
            arrayList2.add(this.attrAlias2);
        }
        if (this.attrAlias3 != null) {
            arrayList2.add(this.attrAlias3);
        }
        if (this.attrPhone != null) {
            arrayList2.add(this.attrPhone);
        }
        searchControls.setReturningAttributes(arrayList2.toArray(new String[0]));
        PagedResultsControl pagedResultsControl = new PagedResultsControl(100, true);
        do {
            initialLdapContext.setRequestControls(new Control[]{pagedResultsControl});
            NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search(this.baseDN, this.filter, searchControls);
            while (namingEnumeration.hasMore()) {
                String string;
                object = namingEnumeration.next().getAttributes();
                String string2 = null;
                try {
                    string2 = ((String)object.get(this.attrUsername).get()).toLowerCase();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                String string3 = null;
                try {
                    string3 = (String)object.get(this.attrEmail).get();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (string3 == null || string3.isEmpty()) {
                    string3 = this.defaultEmail;
                }
                String string4 = null;
                try {
                    string4 = (String)object.get(this.attrName).get();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (string4 == null || string4.isEmpty()) {
                    string4 = this.defaultName;
                }
                User user = new User(string2, string3, string4);
                if (this.attrAlias1 != null) {
                    try {
                        string = (String)object.get(this.attrAlias1).get();
                        if (this.normalizeAttrAlias1.booleanValue()) {
                            string = LDAPWrapper.normalize(string);
                        }
                        user.setAlias1(string);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (this.attrAlias2 != null) {
                    try {
                        string = (String)object.get(this.attrAlias2).get();
                        if (this.normalizeAttrAlias2.booleanValue()) {
                            string = LDAPWrapper.normalize(string);
                        }
                        user.setAlias2(string);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (this.attrAlias3 != null) {
                    try {
                        string = (String)object.get(this.attrAlias3).get();
                        if (this.normalizeAttrAlias3.booleanValue()) {
                            string = LDAPWrapper.normalize(string);
                        }
                        user.setAlias3(string);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (this.attrPhone != null) {
                    try {
                        string = (String)object.get(this.attrPhone).get();
                        user.addPhone(string);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                arrayList.add(user);
            }
        } while ((pagedResultsControl = ((Optional)(object = Arrays.stream(initialLdapContext.getResponseControls()).filter(control -> control instanceof PagedResultsResponseControl).findFirst().map(control -> ((PagedResultsResponseControl)control).getCookie()))).isPresent() ? new PagedResultsControl(100, (byte[])((Optional)object).get(), true) : null) != null);
        return arrayList;
    }

    private static String normalize(String string) {
        String string2 = string;
        if (string != null) {
            if (string.indexOf("@") != -1) {
                string2 = string.substring(0, string.indexOf("@"));
            } else if (string.lastIndexOf("\\") != -1) {
                string2 = string.substring(string.lastIndexOf("\\") + 1);
            }
        }
        return string2;
    }

    public static enum Encryption {
        NONE,
        SSL,
        STARTTLS;


        public static Encryption fromString(String string) {
            if (string == null) {
                return NONE;
            }
            if ("starttls".equals(string = string.toLowerCase())) {
                return STARTTLS;
            }
            if ("ssl".equals(string)) {
                return SSL;
            }
            return NONE;
        }
    }
}

