/*
 * Decompiled with CFR 0.152.
 */
package com.cyphercor.logintc.sync;

import com.cyphercor.logintc.LoginTC;
import com.cyphercor.logintc.resource.AsyncJob;
import com.cyphercor.logintc.resource.Domain;
import com.cyphercor.logintc.resource.User;
import com.cyphercor.logintc.sync.AesGcmEncryptor;
import com.cyphercor.logintc.sync.LDAPWrapper;
import com.cyphercor.logintc.sync.NormalizeAlias;
import com.cyphercor.logintc.util.PrettyPrinter;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SimpleTimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Wini;

public class Main {
    private static Options options = null;
    private static Wini ini = null;
    private static Boolean dryRun = false;
    private static Boolean followReferral = true;
    private static String defaultName = null;
    private static String defaultEmail = null;
    private static final SimpleDateFormat DATE_FORMAT_ISO8601 = Main.initializeSimpleDateFormat();

    private static final SimpleDateFormat initializeSimpleDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(2, "UTC"));
        return simpleDateFormat;
    }

    public static void main(String[] stringArray) {
        block45: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            options = new Options();
            options.addOption("d", "dry-run", false, "Fetch users from LDAP but don't sync them.");
            options.addOption("e", "default-email", true, "Specify a default email to be used when the email is missing.");
            options.addOption("h", "help", false, "Display this help message.");
            options.addOption("i", "ignore-referral", false, "Ignore LDAP referrals.");
            options.addOption("j", "job-status", true, "jobId. Get job status.");
            options.addOption("l", "email-notification", true, "E.g. john.doe@example.com. An email confirming new and removed will be sent to the specific email address. The email address must match an existing administrators email or it will be ignored.");
            options.addOption("m", "sync-mode", true, "[add_only|remove|delete]. add_only will only add users and not remove or delete. In remove mode users are removed from the domain, while in delete mode users are also deleted from the organization. Default is add_only.");
            options.addOption("n", "default-name", true, "Specify a default name to be used when the name is missing.");
            options.addOption("r", "max-remove-limit", true, "Maximum number of remove actions (either remove from domain or delete) that can be performed. If the limit is reach no remove actions are made. Default is 0.");
            options.addOption("t", "sync-token-mode", true, "[do_not_issue_token|issue_token_with_email|issue_token_without_email]. do_not_issue_token will not issue tokens for newly added users. In issue_token_with_email mode newly added users are issued a token with an email, while in issue_token_without_email mode no email is sent. Default is do_not_issue_token.");
            options.addOption("a", "local-validation", false, "Perform local user data validation and fail if there is missing data.");
            options.addOption("g", "group", true, "Add all users to LoginTC group.");
            options.addOption("v", "version", false, "Display the version number.");
            options.addOption("s", "encrypt-secret", false, "Encrypt a single sensitive value for use in configuration file.");
            options.addOption("c", "encrypt-migrate", true, "Migrate configuration file to use encrypted secrets.");
            PosixParser posixParser = new PosixParser();
            CommandLine commandLine = null;
            List list = null;
            Domain.SyncMode syncMode = Domain.SyncMode.ADD_ONLY;
            Domain.SyncTokenMode syncTokenMode = Domain.SyncTokenMode.DO_NOT_ISSUE_TOKEN;
            Integer n = 0;
            String string = null;
            String string2 = null;
            try {
                commandLine = posixParser.parse(options, stringArray);
            }
            catch (ParseException parseException) {
                Main.usage(parseException.getLocalizedMessage());
            }
            if (commandLine.hasOption("help")) {
                Main.usage(0);
            }
            if (commandLine.hasOption("version")) {
                System.out.println("LoginTC Sync Tool " + Main.class.getPackage().getImplementationVersion());
                System.exit(0);
            }
            list = commandLine.getArgList();
            if (commandLine.hasOption("encrypt-secret")) {
                try {
                    object4 = AesGcmEncryptor.getInstance();
                    object3 = System.console();
                    if (object3 != null) {
                        object2 = ((Console)object3).readPassword("Enter value to encrypt: ", new Object[0]);
                        object = new String((char[])object2);
                        Arrays.fill((char[])object2, ' ');
                    } else {
                        System.out.print("Enter value to encrypt: ");
                        object2 = new Scanner(System.in);
                        object = ((Scanner)object2).nextLine();
                        ((Scanner)object2).close();
                    }
                    if (object == null || ((String)object).trim().isEmpty()) {
                        System.err.println("ERROR: No value provided.");
                        System.exit(1);
                    }
                    object2 = ((AesGcmEncryptor)object4).encrypt((String)object);
                    System.out.println();
                    System.out.println("Encrypted value:");
                    System.out.println((String)object2);
                    System.out.println();
                    System.out.println("Copy the above value to your configuration file.");
                    System.exit(0);
                }
                catch (Exception exception) {
                    System.err.println("ERROR: Encryption failed: " + exception.getMessage());
                    System.exit(1);
                }
            }
            if (commandLine.hasOption("encrypt-migrate")) {
                try {
                    object4 = AesGcmEncryptor.getInstance();
                    object3 = commandLine.getOptionValue("encrypt-migrate");
                    if (object3 == null || ((String)object3).trim().isEmpty()) {
                        System.err.println("ERROR: Configuration file path required for --encrypt-migrate option.");
                        Main.usage(1);
                    }
                    Main.encryptConfigFile((String)object3, (AesGcmEncryptor)object4);
                    System.exit(0);
                }
                catch (Exception exception) {
                    System.err.println("ERROR: Migration failed: " + exception.getMessage());
                    System.exit(1);
                }
            }
            if (list.size() == 0) {
                Main.usage("configuration file required");
            }
            try {
                ini = new Wini(new File((String)list.get(list.size() - 1)));
            }
            catch (InvalidFileFormatException invalidFileFormatException) {
                Main.usage(invalidFileFormatException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                Main.usage(iOException);
            }
            Main.checkUnencryptedSecrets(ini, (String)list.get(list.size() - 1));
            if (commandLine.hasOption("job-status")) {
                object4 = commandLine.getOptionValue("job-status", null);
                if (object4 == null || !((String)object4).toLowerCase().matches("[0123456789abcdef]{40}")) {
                    Main.usage("Invalid jobId specified.");
                }
                object3 = Main.getLoginTCClient(ini);
                try {
                    object = ((LoginTC)object3).getAsyncJob((String)object4);
                    if (object != null) {
                        System.out.println(String.format("Job ID: %s", ((AsyncJob)object).getId()));
                        System.out.println(String.format("Job Type: %s", new Object[]{((AsyncJob)object).getType()}));
                        System.out.println(String.format("Job Status: %s", new Object[]{((AsyncJob)object).getStatus()}));
                        System.out.println(String.format("Job Date Created: %s", Main.getOrDefault(DATE_FORMAT_ISO8601.format(((AsyncJob)object).getDtCreated()), "Unknown")));
                        System.out.println(String.format("Job Date Started: %s", Main.getOrDefault(DATE_FORMAT_ISO8601.format(((AsyncJob)object).getDtStarted()), "Unknown")));
                        System.out.println(String.format("Job Date Completed: %s", Main.getOrDefault(DATE_FORMAT_ISO8601.format(((AsyncJob)object).getDtCompleted()), "Unknown")));
                        System.out.println(String.format("Job Actions (approx.): %s of %s", Main.getOrDefault(((AsyncJob)object).getCompletedActions(), "Unknown"), Main.getOrDefault(((AsyncJob)object).getTotalActions(), "Unknown")));
                        System.out.println(String.format("Job Error Code:", Main.getOrDefault(((AsyncJob)object).getErrorCode(), "N/A")));
                        System.out.println(String.format("Job Error Message:", Main.getOrDefault(((AsyncJob)object).getErrorMessage(), "N/A")));
                        System.exit(0);
                    } else {
                        Main.usage("Job not found.");
                    }
                }
                catch (LoginTC.LoginTCException loginTCException) {
                    Main.usage(loginTCException);
                }
            }
            if (commandLine.hasOption("dry-run")) {
                dryRun = true;
            }
            if (commandLine.hasOption("ignore-referral")) {
                followReferral = false;
            }
            if (commandLine.hasOption("default-name")) {
                defaultName = commandLine.getOptionValue("default-name", null);
            }
            if (commandLine.hasOption("default-email")) {
                defaultEmail = commandLine.getOptionValue("default-email", null);
            }
            if (commandLine.hasOption("sync-mode") && (syncMode = Domain.SyncMode.fromString(commandLine.getOptionValue("sync-mode"))) == null) {
                Main.usage("Invalid mode specified. [add_only|remove|delete].");
            }
            if (commandLine.hasOption("sync-token-mode") && (syncTokenMode = Domain.SyncTokenMode.fromString(commandLine.getOptionValue("sync-token-mode"))) == null) {
                Main.usage("Invalid mode specified. [do_not_issue_token|issue_token_with_email|issue_token_without_email].");
            }
            if (commandLine.hasOption("max-remove-limit") && ((n = Integer.valueOf(commandLine.getOptionValue("max-remove-limit"))) == null || n < 0)) {
                Main.usage("Invalid max-remove-limit specified.");
            }
            if (commandLine.hasOption("email-notification")) {
                string = commandLine.getOptionValue("email-notification");
            }
            if (commandLine.hasOption("group")) {
                string2 = commandLine.getOptionValue("group");
            }
            System.out.println("Fetching users...");
            object4 = Main.fetchUsers();
            System.out.println("Fetched " + object4.size() + " user(s)");
            if (object4.size() > 0) {
                Main.printUsers(object4);
            }
            if (commandLine.hasOption("local-validation")) {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object = object3.next();
                    if (object != null && ((User)object).getEmail() != null && ((User)object).getName() != null && ((User)object).getUsername() != null) continue;
                    Main.usage("One or more users have missing fields. Synchronization failed.");
                }
            }
            try {
                AsyncJob.AsyncJobStatus asyncJobStatus;
                if (dryRun.booleanValue()) break block45;
                System.out.println("Synchronizing users...");
                object3 = Main.getLoginTCClient(ini);
                object = ((LoginTC)object3).syncDomainUsers(Main.getDomainId(ini), (List<User>)object4, syncMode, syncTokenMode, n, string, string2);
                System.out.println(String.format("Async Job created with id: %s", ((AsyncJob)object).getId()));
                object2 = ((AsyncJob)object).getId();
                do {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Main.usage(interruptedException);
                    }
                    object = ((LoginTC)object3).getAsyncJob((String)object2);
                    asyncJobStatus = ((AsyncJob)object).getStatus();
                    String string3 = Main.defaultValue(((AsyncJob)object).getCompletedActions(), "Unknown");
                    String string4 = Main.defaultValue(((AsyncJob)object).getTotalActions(), "Unknown");
                    System.out.println(String.format("Status: %s. Completed %s of %s action(s) (approx.).", new Object[]{asyncJobStatus, string3, string4}));
                } while (!asyncJobStatus.isDone());
                switch (asyncJobStatus) {
                    case COMPLETED: {
                        System.out.println("Job completed successfully.");
                        break;
                    }
                    case FAILED: {
                        String string5 = Main.defaultValue(((AsyncJob)object).getErrorCode(), "Unknown");
                        String string6 = Main.defaultValue(((AsyncJob)object).getErrorMessage(), "Unknown");
                        System.out.println(String.format("Job completed in failure. (%s, %s)", string5, string6));
                    }
                }
            }
            catch (LoginTC.LoginTCException loginTCException) {
                Main.usage(loginTCException);
            }
        }
    }

    private static String defaultValue(Object object, String string) {
        if (object != null) {
            return object.toString();
        }
        return string;
    }

    private static List<User> fetchUsers() {
        List list;
        String string2;
        String[] stringArray;
        Map map = (Map)ini.get("ldap");
        for (String string2 : stringArray = new String[]{"host", "encryption", "base_dn", "bind_dn", "attr_username", "attr_name", "attr_email", "filter"}) {
            if (map.containsKey(string2)) continue;
            Main.usage("Configuration section [ldap] is missing property " + string2);
        }
        String string3 = (String)map.get("host");
        String string4 = (String)map.get("encryption");
        String string5 = (String)map.get("base_dn");
        string2 = (String)map.get("bind_dn");
        String string6 = Main.getConfigValue(map, "bind_password", "bind_password_encrypted", "ldap");
        String string7 = (String)map.get("attr_username");
        String string8 = (String)map.get("attr_name");
        String string9 = (String)map.get("attr_email");
        String string10 = (String)map.get("filter");
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        Boolean bl = false;
        Boolean bl2 = false;
        Boolean bl3 = false;
        if (map.containsKey("attr_alias1")) {
            string11 = (String)map.get("attr_alias1");
        }
        if (map.containsKey("attr_alias2")) {
            string12 = (String)map.get("attr_alias2");
        }
        if (map.containsKey("attr_alias3")) {
            string13 = (String)map.get("attr_alias3");
        }
        if (map.containsKey("attr_phone")) {
            string14 = (String)map.get("attr_phone");
        }
        if (map.containsKey("normalize_alias")) {
            list = Arrays.stream(((String)map.get("normalize_alias")).split("\\s*,\\s*")).map(NormalizeAlias::fromString).distinct().collect(Collectors.toList());
            if (list.contains((Object)NormalizeAlias.ALIAS1)) {
                bl = true;
            }
            if (list.contains((Object)NormalizeAlias.ALIAS2)) {
                bl2 = true;
            }
            if (list.contains((Object)NormalizeAlias.ALIAS3)) {
                bl3 = true;
            }
        }
        list = new LDAPWrapper(LDAPWrapper.Encryption.fromString(string4), string3, string5, string2, string6, string7, string8, string9, string11, string12, string13, string14, string10, defaultName, defaultEmail, bl, bl2, bl3);
        List<User> list2 = null;
        try {
            list2 = ((LDAPWrapper)((Object)list)).fetchUsers(followReferral);
        }
        catch (NamingException iOException) {
            Main.usage(iOException);
        }
        catch (IOException iOException) {
            Main.usage(iOException);
        }
        return list2;
    }

    private static void printUsers(List<User> list) {
        int n = 3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (User user : list) {
            if (user.getAlias1() != null) {
                if (!bl) {
                    ++n;
                }
                bl = true;
            }
            if (user.getAlias2() != null) {
                if (!bl2) {
                    ++n;
                }
                bl2 = true;
            }
            if (user.getAlias3() != null) {
                if (!bl3) {
                    ++n;
                }
                bl3 = true;
            }
            if (user.getPhone() == null) continue;
            if (!bl4) {
                ++n;
            }
            bl4 = true;
        }
        String[][] stringArray = new String[list.size() + 1][n];
        int n2 = 0;
        stringArray[0][n2++] = "Username";
        stringArray[0][n2++] = "Name";
        stringArray[0][n2++] = "Email";
        if (bl) {
            stringArray[0][n2++] = "Alias1 (Opt)";
        }
        if (bl2) {
            stringArray[0][n2++] = "Alias2 (Opt)";
        }
        if (bl3) {
            stringArray[0][n2++] = "Alias3 (Opt)";
        }
        if (bl4) {
            stringArray[0][n2++] = "Phone (Opt)";
        }
        int n3 = 1;
        for (User user : list) {
            n2 = 0;
            stringArray[n3][n2++] = user.getUsername();
            stringArray[n3][n2++] = user.getName();
            stringArray[n3][n2++] = user.getEmail();
            if (bl) {
                stringArray[n3][n2++] = user.getAlias1();
            }
            if (bl2) {
                stringArray[n3][n2++] = user.getAlias2();
            }
            if (bl3) {
                stringArray[n3][n2++] = user.getAlias3();
            }
            if (bl4) {
                stringArray[n3][n2++] = user.getPhone();
            }
            ++n3;
        }
        PrettyPrinter prettyPrinter = new PrettyPrinter(System.out, "MISSING!");
        prettyPrinter.print(stringArray);
    }

    private static void usage(Exception exception) {
        System.out.println("Error: " + exception.toString() + "\n");
        Main.usage(1);
    }

    private static void usage(String string) {
        System.out.println("Error: " + string + "\n");
        Main.usage(1);
    }

    private static void usage(int n) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("logintc-sync [options] file", options);
        System.out.println();
        System.out.println("ENCRYPTION:");
        System.out.println("  Encrypt a single value:");
        System.out.println("    java -jar logintc-sync.jar --encrypt-secret");
        System.out.println();
        System.out.println("  Migrate config file to use encrypted secrets:");
        System.out.println("    java -jar logintc-sync.jar --encrypt-migrate config.cfg");
        System.out.println();
        System.out.println("  Encryption key stored in: key.bin (auto-generated on first use)");
        System.out.println("  Supported encrypted properties:");
        System.out.println("    [ldap] bind_password_encrypted");
        System.out.println("    [logintc] api_key_encrypted");
        System.out.println("    [logintc] proxy_pass_encrypted");
        System.exit(n);
    }

    /*
     * WARNING - void declaration
     */
    private static LoginTC getLoginTCClient(Wini wini) {
        void var6_11;
        Map map = (Map)wini.get("logintc");
        String[] stringArray = new String[]{"host"};
        for (String object2 : stringArray) {
            if (map.containsKey(object2)) continue;
            Main.usage("Configuration section [logintc] is missing property " + object2);
        }
        Object object3 = "https";
        String string = "cloud.logintc.com";
        Integer n = 443;
        Boolean bl = true;
        String string2 = (String)map.get("host");
        String string3 = Main.getConfigValue(map, "api_key", "api_key_encrypted", "logintc");
        Pattern pattern = Pattern.compile("^(https|http)?(://)?(.+?):?([0-9]+)?$");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            if (matcher.group(1) != null && ((String)(object3 = matcher.group(1))).equals("http")) {
                n = 80;
            }
            string = matcher.group(3);
            if (matcher.group(4) != null) {
                n = Integer.parseInt(matcher.group(4));
            }
        } else {
            Main.usage("Configuration value host in section [logintc] is invalid: " + string2);
        }
        if (map.containsKey("secure")) {
            Boolean bl2 = Boolean.valueOf((String)map.get("secure"));
        }
        LoginTC loginTC = new LoginTC(string3, String.format("%s:%s", string, n), (Boolean)var6_11);
        if (map.containsKey("proxy_host") && map.containsKey("proxy_port")) {
            String string4 = (String)map.get("proxy_host");
            Integer n2 = Integer.valueOf((String)map.get("proxy_port"));
            if (map.containsKey("proxy_user") && (map.containsKey("proxy_pass") || map.containsKey("proxy_pass_encrypted"))) {
                String string5 = (String)map.get("proxy_user");
                String string6 = Main.getConfigValue(map, "proxy_pass", "proxy_pass_encrypted", "logintc");
                loginTC.setProxy(string4, n2, string5, string6);
            } else {
                loginTC.setProxy(string4, n2);
            }
        }
        return loginTC;
    }

    private static String getDomainId(Wini wini) {
        String[] stringArray;
        Map map = (Map)wini.get("logintc");
        for (String string : stringArray = new String[]{"domain_id"}) {
            if (map.containsKey(string)) continue;
            Main.usage("Configuration section [logintc] is missing property " + string);
        }
        return (String)map.get("domain_id");
    }

    private static String getOrDefault(Object object, String string) {
        if (object == null) {
            return string;
        }
        return object.toString();
    }

    private static String getConfigValue(Map<String, String> map, String string, String string2, String string3) {
        if (map.containsKey(string2)) {
            try {
                AesGcmEncryptor aesGcmEncryptor = AesGcmEncryptor.getInstance();
                return aesGcmEncryptor.decrypt(map.get(string2));
            }
            catch (Exception exception) {
                Main.usage(String.format("Unable to decrypt %s in section [%s]: %s", string2, string3, exception.getMessage()));
                return null;
            }
        }
        if (map.containsKey(string)) {
            return map.get(string);
        }
        Main.usage(String.format("Configuration section [%s] is missing property %s or %s", string3, string, string2));
        return null;
    }

    private static void checkUnencryptedSecrets(Wini wini, String string) {
        Map map;
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map2 = (Map)wini.get("ldap");
        if (map2 != null && map2.containsKey("bind_password") && !map2.containsKey("bind_password_encrypted")) {
            arrayList.add("[ldap] bind_password");
        }
        if ((map = (Map)wini.get("logintc")) != null) {
            if (map.containsKey("api_key") && !map.containsKey("api_key_encrypted")) {
                arrayList.add("[logintc] api_key");
            }
            if (map.containsKey("proxy_pass") && !map.containsKey("proxy_pass_encrypted")) {
                arrayList.add("[logintc] proxy_pass");
            }
        }
        if (!arrayList.isEmpty()) {
            System.err.println();
            System.err.println("WARNING: Configuration file has unencrypted secrets:");
            for (String string2 : arrayList) {
                System.err.println("  - " + string2);
            }
            System.err.println();
            System.err.println("Run the following command to encrypt them:");
            System.err.println("  java -jar logintc-sync.jar --encrypt-migrate " + string);
            System.err.println();
        }
    }

    private static void encryptConfigFile(String string, AesGcmEncryptor aesGcmEncryptor) throws IOException, GeneralSecurityException {
        String string2;
        Object object;
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("ERROR: Configuration file not found: " + string);
            System.exit(1);
        }
        Wini wini = new Wini(file);
        boolean bl = false;
        System.out.println("Encrypting secrets in: " + string);
        System.out.println();
        Map map = (Map)wini.get("ldap");
        if (map != null && map.containsKey("bind_password")) {
            object = (String)map.get("bind_password");
            string2 = aesGcmEncryptor.encrypt((String)object);
            map.put("bind_password_encrypted", string2);
            map.remove("bind_password");
            System.out.println("[ldap] bind_password -> bind_password_encrypted");
            bl = true;
        }
        if ((object = (Map)wini.get("logintc")) != null) {
            String string3;
            if (object.containsKey("api_key")) {
                string2 = (String)object.get("api_key");
                string3 = aesGcmEncryptor.encrypt(string2);
                object.put("api_key_encrypted", string3);
                object.remove("api_key");
                System.out.println("[logintc] api_key -> api_key_encrypted");
                bl = true;
            }
            if (object.containsKey("proxy_pass")) {
                string2 = (String)object.get("proxy_pass");
                string3 = aesGcmEncryptor.encrypt(string2);
                object.put("proxy_pass_encrypted", string3);
                object.remove("proxy_pass");
                System.out.println("[logintc] proxy_pass -> proxy_pass_encrypted");
                bl = true;
            }
        }
        if (!bl) {
            System.out.println("No unencrypted secrets found in the configuration file.");
            System.out.println("All sensitive values are already encrypted or missing.");
        } else {
            wini.store();
            System.out.println();
            System.out.println("Configuration file updated successfully!");
            System.out.println("Plain text secrets have been replaced with encrypted versions.");
        }
    }
}

