/*
 * Decompiled with CFR 0.152.
 */
package com.cyphercor.logintc.util;

import java.io.PrintStream;

public final class PrettyPrinter {
    private static final char BORDER_KNOT = '+';
    private static final char HORIZONTAL_BORDER = '-';
    private static final char VERTICAL_BORDER = '|';
    private static final String DEFAULT_AS_NULL = "(NULL)";
    private final PrintStream out;
    private final String asNull;

    public PrettyPrinter(PrintStream printStream) {
        this(printStream, DEFAULT_AS_NULL);
    }

    public PrettyPrinter(PrintStream printStream, String string) {
        if (printStream == null) {
            throw new IllegalArgumentException("No print stream provided");
        }
        if (string == null) {
            throw new IllegalArgumentException("No NULL-value placeholder provided");
        }
        this.out = printStream;
        this.asNull = string;
    }

    public void print(String[][] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("No tabular data provided");
        }
        if (stringArray.length == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (String[] stringArray2 : stringArray) {
            if (stringArray2 == null) continue;
            for (String string : stringArray2) {
                if (string == null) {
                    string = this.asNull;
                }
                stringArray[n][n2] = " " + string + " ";
                ++n2;
            }
            n2 = 0;
            ++n;
        }
        int[] nArray = new int[this.getMaxColumns(stringArray)];
        this.adjustColumnWidths(stringArray, nArray);
        this.printPreparedTable(stringArray, nArray, this.getHorizontalBorder(nArray));
    }

    private void printPreparedTable(String[][] stringArray, int[] nArray, String string) {
        int n = string.length();
        int n2 = 0;
        this.out.println(string);
        for (String[] stringArray2 : stringArray) {
            if (stringArray2 == null) continue;
            this.out.println(this.getRow(stringArray2, nArray, n));
            if (++n2 != 1) continue;
            this.out.println(string);
        }
        if (n2 > 1) {
            this.out.println(string);
        }
    }

    private String getRow(String[] stringArray, int[] nArray, int n) {
        StringBuilder stringBuilder = new StringBuilder(n).append('|');
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(PrettyPrinter.padRight(this.getCellValue(PrettyPrinter.safeGet(stringArray, i, null)), nArray[i])).append('|');
        }
        return stringBuilder.toString();
    }

    private String getHorizontalBorder(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append('+');
        for (int n : nArray) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('-');
            }
            stringBuilder.append('+');
        }
        return stringBuilder.toString();
    }

    private int getMaxColumns(String[][] stringArray) {
        int n = 0;
        for (String[] stringArray2 : stringArray) {
            if (stringArray2 == null || stringArray2.length <= n) continue;
            n = stringArray2.length;
        }
        return n;
    }

    private void adjustColumnWidths(String[][] stringArray, int[] nArray) {
        for (String[] stringArray2 : stringArray) {
            if (stringArray2 == null) continue;
            for (int i = 0; i < nArray.length; ++i) {
                String string = this.getCellValue(PrettyPrinter.safeGet(stringArray2, i, this.asNull));
                int n = string.length();
                if (nArray[i] >= n) continue;
                nArray[i] = n;
            }
        }
    }

    private static String padRight(String string, int n) {
        return String.format("%1$-" + n + "s", string);
    }

    private static String safeGet(String[] stringArray, int n, String string) {
        return n < stringArray.length ? stringArray[n] : string;
    }

    private String getCellValue(Object object) {
        return object == null ? this.asNull : object.toString();
    }
}

